// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> RP Rehydration Info. </summary>
    public partial class RecoveryPointRehydrationInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RecoveryPointRehydrationInfo"/>. </summary>
        public RecoveryPointRehydrationInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryPointRehydrationInfo"/>. </summary>
        /// <param name="rehydrationRetentionDuration">
        /// How long the rehydrated RP should be kept
        /// Should be ISO8601 Duration format e.g. "P7D"
        /// </param>
        /// <param name="rehydrationPriority"> Rehydration Priority. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RecoveryPointRehydrationInfo(TimeSpan? rehydrationRetentionDuration, RehydrationPriority? rehydrationPriority, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RehydrationRetentionDuration = rehydrationRetentionDuration;
            RehydrationPriority = rehydrationPriority;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// How long the rehydrated RP should be kept
        /// Should be ISO8601 Duration format e.g. "P7D"
        /// </summary>
        public TimeSpan? RehydrationRetentionDuration { get; set; }
        /// <summary> Rehydration Priority. </summary>
        public RehydrationPriority? RehydrationPriority { get; set; }
    }
}
