// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Defines whether the current recovery mode is file restore or database restore. </summary>
    public readonly partial struct RecoveryMode : IEquatable<RecoveryMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RecoveryMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RecoveryMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string FileRecoveryValue = "FileRecovery";
        private const string WorkloadRecoveryValue = "WorkloadRecovery";
        private const string SnapshotAttachValue = "SnapshotAttach";
        private const string RecoveryUsingSnapshotValue = "RecoveryUsingSnapshot";
        private const string SnapshotAttachAndRecoverValue = "SnapshotAttachAndRecover";

        /// <summary> Invalid. </summary>
        public static RecoveryMode Invalid { get; } = new RecoveryMode(InvalidValue);
        /// <summary> FileRecovery. </summary>
        public static RecoveryMode FileRecovery { get; } = new RecoveryMode(FileRecoveryValue);
        /// <summary> WorkloadRecovery. </summary>
        public static RecoveryMode WorkloadRecovery { get; } = new RecoveryMode(WorkloadRecoveryValue);
        /// <summary> SnapshotAttach. </summary>
        public static RecoveryMode SnapshotAttach { get; } = new RecoveryMode(SnapshotAttachValue);
        /// <summary> RecoveryUsingSnapshot. </summary>
        public static RecoveryMode RecoveryUsingSnapshot { get; } = new RecoveryMode(RecoveryUsingSnapshotValue);
        /// <summary> SnapshotAttachAndRecover. </summary>
        public static RecoveryMode SnapshotAttachAndRecover { get; } = new RecoveryMode(SnapshotAttachAndRecoverValue);
        /// <summary> Determines if two <see cref="RecoveryMode"/> values are the same. </summary>
        public static bool operator ==(RecoveryMode left, RecoveryMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RecoveryMode"/> values are not the same. </summary>
        public static bool operator !=(RecoveryMode left, RecoveryMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RecoveryMode"/>. </summary>
        public static implicit operator RecoveryMode(string value) => new RecoveryMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RecoveryMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RecoveryMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
