// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Gets or sets the status. </summary>
    public readonly partial struct PrivateEndpointConnectionStatus : IEquatable<PrivateEndpointConnectionStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PrivateEndpointConnectionStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PrivateEndpointConnectionStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PendingValue = "Pending";
        private const string ApprovedValue = "Approved";
        private const string RejectedValue = "Rejected";
        private const string DisconnectedValue = "Disconnected";

        /// <summary> Pending. </summary>
        public static PrivateEndpointConnectionStatus Pending { get; } = new PrivateEndpointConnectionStatus(PendingValue);
        /// <summary> Approved. </summary>
        public static PrivateEndpointConnectionStatus Approved { get; } = new PrivateEndpointConnectionStatus(ApprovedValue);
        /// <summary> Rejected. </summary>
        public static PrivateEndpointConnectionStatus Rejected { get; } = new PrivateEndpointConnectionStatus(RejectedValue);
        /// <summary> Disconnected. </summary>
        public static PrivateEndpointConnectionStatus Disconnected { get; } = new PrivateEndpointConnectionStatus(DisconnectedValue);
        /// <summary> Determines if two <see cref="PrivateEndpointConnectionStatus"/> values are the same. </summary>
        public static bool operator ==(PrivateEndpointConnectionStatus left, PrivateEndpointConnectionStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PrivateEndpointConnectionStatus"/> values are not the same. </summary>
        public static bool operator !=(PrivateEndpointConnectionStatus left, PrivateEndpointConnectionStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PrivateEndpointConnectionStatus"/>. </summary>
        public static implicit operator PrivateEndpointConnectionStatus(string value) => new PrivateEndpointConnectionStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PrivateEndpointConnectionStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PrivateEndpointConnectionStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
