// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Response contract for enable backup validation request. </summary>
    public partial class PreValidateEnableBackupResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PreValidateEnableBackupResult"/>. </summary>
        internal PreValidateEnableBackupResult()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PreValidateEnableBackupResult"/>. </summary>
        /// <param name="status"> Validation Status. </param>
        /// <param name="errorCode"> Response error code. </param>
        /// <param name="errorMessage"> Response error message. </param>
        /// <param name="recommendation"> Recommended action for user. </param>
        /// <param name="containerName">
        /// Specifies the product specific container name. E.g. iaasvmcontainer;iaasvmcontainer;rgname;vmname. This is required
        /// for portal
        /// </param>
        /// <param name="protectedItemName"> Specifies the product specific ds name. E.g. vm;iaasvmcontainer;rgname;vmname. This is required for portal. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PreValidateEnableBackupResult(BackupValidationStatus? status, string errorCode, string errorMessage, string recommendation, string containerName, string protectedItemName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Status = status;
            ErrorCode = errorCode;
            ErrorMessage = errorMessage;
            Recommendation = recommendation;
            ContainerName = containerName;
            ProtectedItemName = protectedItemName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Validation Status. </summary>
        public BackupValidationStatus? Status { get; }
        /// <summary> Response error code. </summary>
        public string ErrorCode { get; }
        /// <summary> Response error message. </summary>
        public string ErrorMessage { get; }
        /// <summary> Recommended action for user. </summary>
        public string Recommendation { get; }
        /// <summary>
        /// Specifies the product specific container name. E.g. iaasvmcontainer;iaasvmcontainer;rgname;vmname. This is required
        /// for portal
        /// </summary>
        public string ContainerName { get; }
        /// <summary> Specifies the product specific ds name. E.g. vm;iaasvmcontainer;rgname;vmname. This is required for portal. </summary>
        public string ProtectedItemName { get; }
    }
}
