// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary>
    /// Contract to validate if backup can be enabled on the given resource in a given vault and given configuration.
    /// It will validate followings
    /// 1. Vault capacity
    /// 2. VM is already protected
    /// 3. Any VM related configuration passed in properties.
    /// </summary>
    public partial class PreValidateEnableBackupContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PreValidateEnableBackupContent"/>. </summary>
        public PreValidateEnableBackupContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PreValidateEnableBackupContent"/>. </summary>
        /// <param name="resourceType"> ProtectedItem Type- VM, SqlDataBase, AzureFileShare etc. </param>
        /// <param name="resourceId"> ARM Virtual Machine Id. </param>
        /// <param name="vaultId"> ARM id of the Recovery Services Vault. </param>
        /// <param name="properties"> Configuration of VM if any needs to be validated like OS type etc. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PreValidateEnableBackupContent(BackupDataSourceType? resourceType, ResourceIdentifier resourceId, ResourceIdentifier vaultId, string properties, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ResourceType = resourceType;
            ResourceId = resourceId;
            VaultId = vaultId;
            Properties = properties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> ProtectedItem Type- VM, SqlDataBase, AzureFileShare etc. </summary>
        public BackupDataSourceType? ResourceType { get; set; }
        /// <summary> ARM Virtual Machine Id. </summary>
        public ResourceIdentifier ResourceId { get; set; }
        /// <summary> ARM id of the Recovery Services Vault. </summary>
        public ResourceIdentifier VaultId { get; set; }
        /// <summary> Configuration of VM if any needs to be validated like OS type etc. </summary>
        public string Properties { get; set; }
    }
}
