// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Pre-backup validation for Azure VM Workload provider. </summary>
    public partial class PreBackupValidation
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PreBackupValidation"/>. </summary>
        public PreBackupValidation()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PreBackupValidation"/>. </summary>
        /// <param name="status"> Status of protectable item, i.e. InProgress,Succeeded,Failed. </param>
        /// <param name="code"> Error code of protectable item. </param>
        /// <param name="message"> Message corresponding to the error code for the protectable item. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PreBackupValidation(InquiryStatus? status, string code, string message, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Status = status;
            Code = code;
            Message = message;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Status of protectable item, i.e. InProgress,Succeeded,Failed. </summary>
        public InquiryStatus? Status { get; set; }
        /// <summary> Error code of protectable item. </summary>
        public string Code { get; set; }
        /// <summary> Message corresponding to the error code for the protectable item. </summary>
        public string Message { get; set; }
    }
}
