// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    public partial class MoveRPAcrossTiersContent : IUtf8JsonSerializable, IJsonModel<MoveRPAcrossTiersContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<MoveRPAcrossTiersContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<MoveRPAcrossTiersContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MoveRPAcrossTiersContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MoveRPAcrossTiersContent)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ObjectType))
            {
                writer.WritePropertyName("objectType"u8);
                writer.WriteStringValue(ObjectType);
            }
            if (Optional.IsDefined(SourceTierType))
            {
                writer.WritePropertyName("sourceTierType"u8);
                writer.WriteStringValue(SourceTierType.Value.ToSerialString());
            }
            if (Optional.IsDefined(TargetTierType))
            {
                writer.WritePropertyName("targetTierType"u8);
                writer.WriteStringValue(TargetTierType.Value.ToSerialString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        MoveRPAcrossTiersContent IJsonModel<MoveRPAcrossTiersContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MoveRPAcrossTiersContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MoveRPAcrossTiersContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeMoveRPAcrossTiersContent(document.RootElement, options);
        }

        internal static MoveRPAcrossTiersContent DeserializeMoveRPAcrossTiersContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string objectType = default;
            RecoveryPointTierType? sourceTierType = default;
            RecoveryPointTierType? targetTierType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("objectType"u8))
                {
                    objectType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("sourceTierType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sourceTierType = property.Value.GetString().ToRecoveryPointTierType();
                    continue;
                }
                if (property.NameEquals("targetTierType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    targetTierType = property.Value.GetString().ToRecoveryPointTierType();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new MoveRPAcrossTiersContent(objectType, sourceTierType, targetTierType, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<MoveRPAcrossTiersContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MoveRPAcrossTiersContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(MoveRPAcrossTiersContent)} does not support writing '{options.Format}' format.");
            }
        }

        MoveRPAcrossTiersContent IPersistableModel<MoveRPAcrossTiersContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MoveRPAcrossTiersContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeMoveRPAcrossTiersContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(MoveRPAcrossTiersContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<MoveRPAcrossTiersContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
