// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Additional information for the MAB workload-specific job. </summary>
    public partial class MabBackupJobExtendedInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MabBackupJobExtendedInfo"/>. </summary>
        public MabBackupJobExtendedInfo()
        {
            TasksList = new ChangeTrackingList<MabBackupJobTaskDetails>();
            PropertyBag = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="MabBackupJobExtendedInfo"/>. </summary>
        /// <param name="tasksList"> List of tasks for this job. </param>
        /// <param name="propertyBag"> The job properties. </param>
        /// <param name="dynamicErrorMessage"> Non localized error message specific to this job. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MabBackupJobExtendedInfo(IList<MabBackupJobTaskDetails> tasksList, IDictionary<string, string> propertyBag, string dynamicErrorMessage, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TasksList = tasksList;
            PropertyBag = propertyBag;
            DynamicErrorMessage = dynamicErrorMessage;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> List of tasks for this job. </summary>
        public IList<MabBackupJobTaskDetails> TasksList { get; }
        /// <summary> The job properties. </summary>
        public IDictionary<string, string> PropertyBag { get; }
        /// <summary> Non localized error message specific to this job. </summary>
        public string DynamicErrorMessage { get; set; }
    }
}
