// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> The LastUpdateStatus. </summary>
    public readonly partial struct LastUpdateStatus : IEquatable<LastUpdateStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LastUpdateStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LastUpdateStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string NotEnabledValue = "NotEnabled";
        private const string PartiallySucceededValue = "PartiallySucceeded";
        private const string PartiallyFailedValue = "PartiallyFailed";
        private const string FailedValue = "Failed";
        private const string SucceededValue = "Succeeded";
        private const string InitializedValue = "Initialized";
        private const string FirstInitializationValue = "FirstInitialization";

        /// <summary> Invalid. </summary>
        public static LastUpdateStatus Invalid { get; } = new LastUpdateStatus(InvalidValue);
        /// <summary> NotEnabled. </summary>
        public static LastUpdateStatus NotEnabled { get; } = new LastUpdateStatus(NotEnabledValue);
        /// <summary> PartiallySucceeded. </summary>
        public static LastUpdateStatus PartiallySucceeded { get; } = new LastUpdateStatus(PartiallySucceededValue);
        /// <summary> PartiallyFailed. </summary>
        public static LastUpdateStatus PartiallyFailed { get; } = new LastUpdateStatus(PartiallyFailedValue);
        /// <summary> Failed. </summary>
        public static LastUpdateStatus Failed { get; } = new LastUpdateStatus(FailedValue);
        /// <summary> Succeeded. </summary>
        public static LastUpdateStatus Succeeded { get; } = new LastUpdateStatus(SucceededValue);
        /// <summary> Initialized. </summary>
        public static LastUpdateStatus Initialized { get; } = new LastUpdateStatus(InitializedValue);
        /// <summary> FirstInitialization. </summary>
        public static LastUpdateStatus FirstInitialization { get; } = new LastUpdateStatus(FirstInitializationValue);
        /// <summary> Determines if two <see cref="LastUpdateStatus"/> values are the same. </summary>
        public static bool operator ==(LastUpdateStatus left, LastUpdateStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LastUpdateStatus"/> values are not the same. </summary>
        public static bool operator !=(LastUpdateStatus left, LastUpdateStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LastUpdateStatus"/>. </summary>
        public static implicit operator LastUpdateStatus(string value) => new LastUpdateStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LastUpdateStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LastUpdateStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
