// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    public partial class KpiResourceHealthDetails : IUtf8JsonSerializable, IJsonModel<KpiResourceHealthDetails>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<KpiResourceHealthDetails>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<KpiResourceHealthDetails>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<KpiResourceHealthDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(KpiResourceHealthDetails)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ResourceHealthStatus))
            {
                writer.WritePropertyName("resourceHealthStatus"u8);
                writer.WriteStringValue(ResourceHealthStatus.Value.ToString());
            }
            if (Optional.IsCollectionDefined(ResourceHealthDetails))
            {
                writer.WritePropertyName("resourceHealthDetails"u8);
                writer.WriteStartArray();
                foreach (var item in ResourceHealthDetails)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        KpiResourceHealthDetails IJsonModel<KpiResourceHealthDetails>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<KpiResourceHealthDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(KpiResourceHealthDetails)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeKpiResourceHealthDetails(document.RootElement, options);
        }

        internal static KpiResourceHealthDetails DeserializeKpiResourceHealthDetails(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceHealthStatus? resourceHealthStatus = default;
            IList<ResourceHealthDetails> resourceHealthDetails = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("resourceHealthStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    resourceHealthStatus = new ResourceHealthStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("resourceHealthDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ResourceHealthDetails> array = new List<ResourceHealthDetails>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(Models.ResourceHealthDetails.DeserializeResourceHealthDetails(item, options));
                    }
                    resourceHealthDetails = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new KpiResourceHealthDetails(resourceHealthStatus, resourceHealthDetails ?? new ChangeTrackingList<ResourceHealthDetails>(), serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<KpiResourceHealthDetails>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<KpiResourceHealthDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(KpiResourceHealthDetails)} does not support writing '{options.Format}' format.");
            }
        }

        KpiResourceHealthDetails IPersistableModel<KpiResourceHealthDetails>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<KpiResourceHealthDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeKpiResourceHealthDetails(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(KpiResourceHealthDetails)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<KpiResourceHealthDetails>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
