// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary>
    /// BEK is bitlocker key.
    /// KEK is encryption key for BEK
    /// If the VM was encrypted then we will store following details :
    /// 1. Secret(BEK) - Url + Backup Data + vaultId.
    /// 2. Key(KEK) - Url + Backup Data + vaultId.
    /// 3. EncryptionMechanism
    /// BEK and KEK can potentially have different vault ids.
    /// </summary>
    public partial class KeyAndSecretDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="KeyAndSecretDetails"/>. </summary>
        public KeyAndSecretDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="KeyAndSecretDetails"/>. </summary>
        /// <param name="kekDetails"> KEK is encryption key for BEK. </param>
        /// <param name="bekDetails"> BEK is bitlocker encryption key. </param>
        /// <param name="encryptionMechanism"> Encryption mechanism: None/ SinglePass/ DoublePass. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal KeyAndSecretDetails(KekDetails kekDetails, BekDetails bekDetails, string encryptionMechanism, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            KekDetails = kekDetails;
            BekDetails = bekDetails;
            EncryptionMechanism = encryptionMechanism;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> KEK is encryption key for BEK. </summary>
        public KekDetails KekDetails { get; set; }
        /// <summary> BEK is bitlocker encryption key. </summary>
        public BekDetails BekDetails { get; set; }
        /// <summary> Encryption mechanism: None/ SinglePass/ DoublePass. </summary>
        public string EncryptionMechanism { get; set; }
    }
}
