// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    internal static partial class JobSupportedActionExtensions
    {
        public static string ToSerialString(this JobSupportedAction value) => value switch
        {
            JobSupportedAction.Invalid => "Invalid",
            JobSupportedAction.Cancellable => "Cancellable",
            JobSupportedAction.Retriable => "Retriable",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown JobSupportedAction value.")
        };

        public static JobSupportedAction ToJobSupportedAction(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Invalid")) return JobSupportedAction.Invalid;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Cancellable")) return JobSupportedAction.Cancellable;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Retriable")) return JobSupportedAction.Retriable;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown JobSupportedAction value.");
        }
    }
}
