// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    public partial class InstantRPAdditionalDetails : IUtf8JsonSerializable, IJsonModel<InstantRPAdditionalDetails>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<InstantRPAdditionalDetails>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<InstantRPAdditionalDetails>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InstantRPAdditionalDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InstantRPAdditionalDetails)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(AzureBackupRGNamePrefix))
            {
                writer.WritePropertyName("azureBackupRGNamePrefix"u8);
                writer.WriteStringValue(AzureBackupRGNamePrefix);
            }
            if (Optional.IsDefined(AzureBackupRGNameSuffix))
            {
                writer.WritePropertyName("azureBackupRGNameSuffix"u8);
                writer.WriteStringValue(AzureBackupRGNameSuffix);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        InstantRPAdditionalDetails IJsonModel<InstantRPAdditionalDetails>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InstantRPAdditionalDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InstantRPAdditionalDetails)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeInstantRPAdditionalDetails(document.RootElement, options);
        }

        internal static InstantRPAdditionalDetails DeserializeInstantRPAdditionalDetails(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string azureBackupRGNamePrefix = default;
            string azureBackupRGNameSuffix = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("azureBackupRGNamePrefix"u8))
                {
                    azureBackupRGNamePrefix = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("azureBackupRGNameSuffix"u8))
                {
                    azureBackupRGNameSuffix = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new InstantRPAdditionalDetails(azureBackupRGNamePrefix, azureBackupRGNameSuffix, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<InstantRPAdditionalDetails>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InstantRPAdditionalDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(InstantRPAdditionalDetails)} does not support writing '{options.Format}' format.");
            }
        }

        InstantRPAdditionalDetails IPersistableModel<InstantRPAdditionalDetails>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InstantRPAdditionalDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeInstantRPAdditionalDetails(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(InstantRPAdditionalDetails)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<InstantRPAdditionalDetails>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
