// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Health status of protected item. </summary>
    public readonly partial struct IaasVmProtectedItemHealthStatus : IEquatable<IaasVmProtectedItemHealthStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IaasVmProtectedItemHealthStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IaasVmProtectedItemHealthStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PassedValue = "Passed";
        private const string ActionRequiredValue = "ActionRequired";
        private const string ActionSuggestedValue = "ActionSuggested";
        private const string InvalidValue = "Invalid";

        /// <summary> Passed. </summary>
        public static IaasVmProtectedItemHealthStatus Passed { get; } = new IaasVmProtectedItemHealthStatus(PassedValue);
        /// <summary> ActionRequired. </summary>
        public static IaasVmProtectedItemHealthStatus ActionRequired { get; } = new IaasVmProtectedItemHealthStatus(ActionRequiredValue);
        /// <summary> ActionSuggested. </summary>
        public static IaasVmProtectedItemHealthStatus ActionSuggested { get; } = new IaasVmProtectedItemHealthStatus(ActionSuggestedValue);
        /// <summary> Invalid. </summary>
        public static IaasVmProtectedItemHealthStatus Invalid { get; } = new IaasVmProtectedItemHealthStatus(InvalidValue);
        /// <summary> Determines if two <see cref="IaasVmProtectedItemHealthStatus"/> values are the same. </summary>
        public static bool operator ==(IaasVmProtectedItemHealthStatus left, IaasVmProtectedItemHealthStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IaasVmProtectedItemHealthStatus"/> values are not the same. </summary>
        public static bool operator !=(IaasVmProtectedItemHealthStatus left, IaasVmProtectedItemHealthStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IaasVmProtectedItemHealthStatus"/>. </summary>
        public static implicit operator IaasVmProtectedItemHealthStatus(string value) => new IaasVmProtectedItemHealthStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IaasVmProtectedItemHealthStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IaasVmProtectedItemHealthStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
