// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> The IaasVmPolicyType. </summary>
    public readonly partial struct IaasVmPolicyType : IEquatable<IaasVmPolicyType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IaasVmPolicyType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IaasVmPolicyType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string V1Value = "V1";
        private const string V2Value = "V2";

        /// <summary> Invalid. </summary>
        public static IaasVmPolicyType Invalid { get; } = new IaasVmPolicyType(InvalidValue);
        /// <summary> V1. </summary>
        public static IaasVmPolicyType V1 { get; } = new IaasVmPolicyType(V1Value);
        /// <summary> V2. </summary>
        public static IaasVmPolicyType V2 { get; } = new IaasVmPolicyType(V2Value);
        /// <summary> Determines if two <see cref="IaasVmPolicyType"/> values are the same. </summary>
        public static bool operator ==(IaasVmPolicyType left, IaasVmPolicyType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IaasVmPolicyType"/> values are not the same. </summary>
        public static bool operator !=(IaasVmPolicyType left, IaasVmPolicyType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IaasVmPolicyType"/>. </summary>
        public static implicit operator IaasVmPolicyType(string value) => new IaasVmPolicyType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IaasVmPolicyType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IaasVmPolicyType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
