// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    public partial class IaasVmIlrRegistrationContent : IUtf8JsonSerializable, IJsonModel<IaasVmIlrRegistrationContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<IaasVmIlrRegistrationContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<IaasVmIlrRegistrationContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IaasVmIlrRegistrationContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(IaasVmIlrRegistrationContent)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(RecoveryPointId))
            {
                writer.WritePropertyName("recoveryPointId"u8);
                writer.WriteStringValue(RecoveryPointId);
            }
            if (Optional.IsDefined(VirtualMachineId))
            {
                writer.WritePropertyName("virtualMachineId"u8);
                writer.WriteStringValue(VirtualMachineId);
            }
            if (Optional.IsDefined(InitiatorName))
            {
                writer.WritePropertyName("initiatorName"u8);
                writer.WriteStringValue(InitiatorName);
            }
            if (Optional.IsDefined(RenewExistingRegistration))
            {
                writer.WritePropertyName("renewExistingRegistration"u8);
                writer.WriteBooleanValue(RenewExistingRegistration.Value);
            }
        }

        IaasVmIlrRegistrationContent IJsonModel<IaasVmIlrRegistrationContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IaasVmIlrRegistrationContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(IaasVmIlrRegistrationContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeIaasVmIlrRegistrationContent(document.RootElement, options);
        }

        internal static IaasVmIlrRegistrationContent DeserializeIaasVmIlrRegistrationContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string recoveryPointId = default;
            ResourceIdentifier virtualMachineId = default;
            string initiatorName = default;
            bool? renewExistingRegistration = default;
            string objectType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("recoveryPointId"u8))
                {
                    recoveryPointId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("virtualMachineId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    virtualMachineId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("initiatorName"u8))
                {
                    initiatorName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("renewExistingRegistration"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    renewExistingRegistration = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("objectType"u8))
                {
                    objectType = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new IaasVmIlrRegistrationContent(
                objectType,
                serializedAdditionalRawData,
                recoveryPointId,
                virtualMachineId,
                initiatorName,
                renewExistingRegistration);
        }

        BinaryData IPersistableModel<IaasVmIlrRegistrationContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IaasVmIlrRegistrationContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(IaasVmIlrRegistrationContent)} does not support writing '{options.Format}' format.");
            }
        }

        IaasVmIlrRegistrationContent IPersistableModel<IaasVmIlrRegistrationContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IaasVmIlrRegistrationContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeIaasVmIlrRegistrationContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(IaasVmIlrRegistrationContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<IaasVmIlrRegistrationContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
