// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Azure IaaS VM workload-specific job task details. </summary>
    public partial class IaasVmBackupJobTaskDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IaasVmBackupJobTaskDetails"/>. </summary>
        public IaasVmBackupJobTaskDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="IaasVmBackupJobTaskDetails"/>. </summary>
        /// <param name="taskId"> The task display name. </param>
        /// <param name="startOn"> The start time. </param>
        /// <param name="endOn"> The end time. </param>
        /// <param name="instanceId"> The instanceId. </param>
        /// <param name="duration"> Time elapsed for task. </param>
        /// <param name="status"> The status. </param>
        /// <param name="progressPercentage"> Progress of the task. </param>
        /// <param name="taskExecutionDetails">
        /// Details about execution of the task.
        /// eg: number of bytes transferred etc
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IaasVmBackupJobTaskDetails(string taskId, DateTimeOffset? startOn, DateTimeOffset? endOn, string instanceId, TimeSpan? duration, string status, double? progressPercentage, string taskExecutionDetails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TaskId = taskId;
            StartOn = startOn;
            EndOn = endOn;
            InstanceId = instanceId;
            Duration = duration;
            Status = status;
            ProgressPercentage = progressPercentage;
            TaskExecutionDetails = taskExecutionDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The task display name. </summary>
        public string TaskId { get; set; }
        /// <summary> The start time. </summary>
        public DateTimeOffset? StartOn { get; set; }
        /// <summary> The end time. </summary>
        public DateTimeOffset? EndOn { get; set; }
        /// <summary> The instanceId. </summary>
        public string InstanceId { get; set; }
        /// <summary> Time elapsed for task. </summary>
        public TimeSpan? Duration { get; set; }
        /// <summary> The status. </summary>
        public string Status { get; set; }
        /// <summary> Progress of the task. </summary>
        public double? ProgressPercentage { get; set; }
        /// <summary>
        /// Details about execution of the task.
        /// eg: number of bytes transferred etc
        /// </summary>
        public string TaskExecutionDetails { get; set; }
    }
}
