// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Azure IaaS VM workload-specific job object. </summary>
    public partial class IaasVmBackupJob : BackupGenericJob
    {
        /// <summary> Initializes a new instance of <see cref="IaasVmBackupJob"/>. </summary>
        public IaasVmBackupJob()
        {
            ActionsInfo = new ChangeTrackingList<JobSupportedAction>();
            ErrorDetails = new ChangeTrackingList<IaasVmErrorInfo>();
            JobType = "AzureIaaSVMJob";
        }

        /// <summary> Initializes a new instance of <see cref="IaasVmBackupJob"/>. </summary>
        /// <param name="entityFriendlyName"> Friendly name of the entity on which the current job is executing. </param>
        /// <param name="backupManagementType"> Backup management type to execute the current job. </param>
        /// <param name="operation"> The operation name. </param>
        /// <param name="status"> Job status. </param>
        /// <param name="startOn"> The start time. </param>
        /// <param name="endOn"> The end time. </param>
        /// <param name="activityId"> ActivityId of job. </param>
        /// <param name="jobType"> This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="duration"> Time elapsed during the execution of this job. </param>
        /// <param name="actionsInfo"> Gets or sets the state/actions applicable on this job like cancel/retry. </param>
        /// <param name="errorDetails"> Error details on execution of this job. </param>
        /// <param name="virtualMachineVersion"> Specifies whether the backup item is a Classic or an Azure Resource Manager VM. </param>
        /// <param name="extendedInfo"> Additional information for this job. </param>
        /// <param name="containerName"> Container name of the entity on which the current job is executing. </param>
        /// <param name="isUserTriggered"> Indicated that whether the job is adhoc(true) or scheduled(false). </param>
        internal IaasVmBackupJob(string entityFriendlyName, BackupManagementType? backupManagementType, string operation, string status, DateTimeOffset? startOn, DateTimeOffset? endOn, string activityId, string jobType, IDictionary<string, BinaryData> serializedAdditionalRawData, TimeSpan? duration, IList<JobSupportedAction> actionsInfo, IList<IaasVmErrorInfo> errorDetails, string virtualMachineVersion, IaasVmBackupJobExtendedInfo extendedInfo, string containerName, bool? isUserTriggered) : base(entityFriendlyName, backupManagementType, operation, status, startOn, endOn, activityId, jobType, serializedAdditionalRawData)
        {
            Duration = duration;
            ActionsInfo = actionsInfo;
            ErrorDetails = errorDetails;
            VirtualMachineVersion = virtualMachineVersion;
            ExtendedInfo = extendedInfo;
            ContainerName = containerName;
            IsUserTriggered = isUserTriggered;
            JobType = jobType ?? "AzureIaaSVMJob";
        }

        /// <summary> Time elapsed during the execution of this job. </summary>
        public TimeSpan? Duration { get; set; }
        /// <summary> Gets or sets the state/actions applicable on this job like cancel/retry. </summary>
        public IList<JobSupportedAction> ActionsInfo { get; }
        /// <summary> Error details on execution of this job. </summary>
        public IList<IaasVmErrorInfo> ErrorDetails { get; }
        /// <summary> Specifies whether the backup item is a Classic or an Azure Resource Manager VM. </summary>
        public string VirtualMachineVersion { get; set; }
        /// <summary> Additional information for this job. </summary>
        public IaasVmBackupJobExtendedInfo ExtendedInfo { get; set; }
        /// <summary> Container name of the entity on which the current job is executing. </summary>
        public string ContainerName { get; set; }
        /// <summary> Indicated that whether the job is adhoc(true) or scheduled(false). </summary>
        public bool? IsUserTriggered { get; set; }
    }
}
