// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Restore Type (FullShareRestore or ItemLevelRestore). </summary>
    public readonly partial struct FileShareRestoreType : IEquatable<FileShareRestoreType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FileShareRestoreType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FileShareRestoreType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string FullShareRestoreValue = "FullShareRestore";
        private const string ItemLevelRestoreValue = "ItemLevelRestore";

        /// <summary> Invalid. </summary>
        public static FileShareRestoreType Invalid { get; } = new FileShareRestoreType(InvalidValue);
        /// <summary> FullShareRestore. </summary>
        public static FileShareRestoreType FullShareRestore { get; } = new FileShareRestoreType(FullShareRestoreValue);
        /// <summary> ItemLevelRestore. </summary>
        public static FileShareRestoreType ItemLevelRestore { get; } = new FileShareRestoreType(ItemLevelRestoreValue);
        /// <summary> Determines if two <see cref="FileShareRestoreType"/> values are the same. </summary>
        public static bool operator ==(FileShareRestoreType left, FileShareRestoreType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FileShareRestoreType"/> values are not the same. </summary>
        public static bool operator !=(FileShareRestoreType left, FileShareRestoreType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FileShareRestoreType"/>. </summary>
        public static implicit operator FileShareRestoreType(string value) => new FileShareRestoreType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FileShareRestoreType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FileShareRestoreType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
