// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    public partial class FileShareRestoreContent : IUtf8JsonSerializable, IJsonModel<FileShareRestoreContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<FileShareRestoreContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<FileShareRestoreContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FileShareRestoreContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FileShareRestoreContent)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(RecoveryType))
            {
                writer.WritePropertyName("recoveryType"u8);
                writer.WriteStringValue(RecoveryType.Value.ToString());
            }
            if (Optional.IsDefined(SourceResourceId))
            {
                writer.WritePropertyName("sourceResourceId"u8);
                writer.WriteStringValue(SourceResourceId);
            }
            if (Optional.IsDefined(CopyOptions))
            {
                writer.WritePropertyName("copyOptions"u8);
                writer.WriteStringValue(CopyOptions.Value.ToString());
            }
            if (Optional.IsDefined(RestoreRequestType))
            {
                writer.WritePropertyName("restoreRequestType"u8);
                writer.WriteStringValue(RestoreRequestType.Value.ToString());
            }
            if (Optional.IsCollectionDefined(RestoreFileSpecs))
            {
                writer.WritePropertyName("restoreFileSpecs"u8);
                writer.WriteStartArray();
                foreach (var item in RestoreFileSpecs)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(TargetDetails))
            {
                writer.WritePropertyName("targetDetails"u8);
                writer.WriteObjectValue(TargetDetails, options);
            }
        }

        FileShareRestoreContent IJsonModel<FileShareRestoreContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FileShareRestoreContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FileShareRestoreContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeFileShareRestoreContent(document.RootElement, options);
        }

        internal static FileShareRestoreContent DeserializeFileShareRestoreContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            FileShareRecoveryType? recoveryType = default;
            ResourceIdentifier sourceResourceId = default;
            FileShareCopyOption? copyOptions = default;
            FileShareRestoreType? restoreRequestType = default;
            IList<RestoreFileSpecs> restoreFileSpecs = default;
            TargetAfsRestoreInfo targetDetails = default;
            string objectType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("recoveryType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    recoveryType = new FileShareRecoveryType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("sourceResourceId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sourceResourceId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("copyOptions"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    copyOptions = new FileShareCopyOption(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("restoreRequestType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    restoreRequestType = new FileShareRestoreType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("restoreFileSpecs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<RestoreFileSpecs> array = new List<RestoreFileSpecs>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(Models.RestoreFileSpecs.DeserializeRestoreFileSpecs(item, options));
                    }
                    restoreFileSpecs = array;
                    continue;
                }
                if (property.NameEquals("targetDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    targetDetails = TargetAfsRestoreInfo.DeserializeTargetAfsRestoreInfo(property.Value, options);
                    continue;
                }
                if (property.NameEquals("objectType"u8))
                {
                    objectType = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new FileShareRestoreContent(
                objectType,
                serializedAdditionalRawData,
                recoveryType,
                sourceResourceId,
                copyOptions,
                restoreRequestType,
                restoreFileSpecs ?? new ChangeTrackingList<RestoreFileSpecs>(),
                targetDetails);
        }

        BinaryData IPersistableModel<FileShareRestoreContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FileShareRestoreContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(FileShareRestoreContent)} does not support writing '{options.Format}' format.");
            }
        }

        FileShareRestoreContent IPersistableModel<FileShareRestoreContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FileShareRestoreContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeFileShareRestoreContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(FileShareRestoreContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<FileShareRestoreContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
