// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Type of this recovery. </summary>
    public readonly partial struct FileShareRecoveryType : IEquatable<FileShareRecoveryType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FileShareRecoveryType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FileShareRecoveryType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string OriginalLocationValue = "OriginalLocation";
        private const string AlternateLocationValue = "AlternateLocation";
        private const string RestoreDisksValue = "RestoreDisks";
        private const string OfflineValue = "Offline";

        /// <summary> Invalid. </summary>
        public static FileShareRecoveryType Invalid { get; } = new FileShareRecoveryType(InvalidValue);
        /// <summary> OriginalLocation. </summary>
        public static FileShareRecoveryType OriginalLocation { get; } = new FileShareRecoveryType(OriginalLocationValue);
        /// <summary> AlternateLocation. </summary>
        public static FileShareRecoveryType AlternateLocation { get; } = new FileShareRecoveryType(AlternateLocationValue);
        /// <summary> RestoreDisks. </summary>
        public static FileShareRecoveryType RestoreDisks { get; } = new FileShareRecoveryType(RestoreDisksValue);
        /// <summary> Offline. </summary>
        public static FileShareRecoveryType Offline { get; } = new FileShareRecoveryType(OfflineValue);
        /// <summary> Determines if two <see cref="FileShareRecoveryType"/> values are the same. </summary>
        public static bool operator ==(FileShareRecoveryType left, FileShareRecoveryType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FileShareRecoveryType"/> values are not the same. </summary>
        public static bool operator !=(FileShareRecoveryType left, FileShareRecoveryType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FileShareRecoveryType"/>. </summary>
        public static implicit operator FileShareRecoveryType(string value) => new FileShareRecoveryType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FileShareRecoveryType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FileShareRecoveryType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
