// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    [PersistableModelProxy(typeof(UnknownFetchTieringCostInfoRequest))]
    public partial class FetchTieringCostInfoContent : IUtf8JsonSerializable, IJsonModel<FetchTieringCostInfoContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<FetchTieringCostInfoContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<FetchTieringCostInfoContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FetchTieringCostInfoContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FetchTieringCostInfoContent)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("sourceTierType"u8);
            writer.WriteStringValue(SourceTierType.ToSerialString());
            writer.WritePropertyName("targetTierType"u8);
            writer.WriteStringValue(TargetTierType.ToSerialString());
            writer.WritePropertyName("objectType"u8);
            writer.WriteStringValue(ObjectType);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        FetchTieringCostInfoContent IJsonModel<FetchTieringCostInfoContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FetchTieringCostInfoContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FetchTieringCostInfoContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeFetchTieringCostInfoContent(document.RootElement, options);
        }

        internal static FetchTieringCostInfoContent DeserializeFetchTieringCostInfoContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("objectType", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "FetchTieringCostInfoForRehydrationRequest": return FetchTieringCostInfoForRehydrationContent.DeserializeFetchTieringCostInfoForRehydrationContent(element, options);
                    case "FetchTieringCostSavingsInfoForPolicyRequest": return FetchTieringCostSavingsInfoForPolicyContent.DeserializeFetchTieringCostSavingsInfoForPolicyContent(element, options);
                    case "FetchTieringCostSavingsInfoForProtectedItemRequest": return FetchTieringCostSavingsInfoForProtectedItemContent.DeserializeFetchTieringCostSavingsInfoForProtectedItemContent(element, options);
                    case "FetchTieringCostSavingsInfoForVaultRequest": return FetchTieringCostSavingsInfoForVaultContent.DeserializeFetchTieringCostSavingsInfoForVaultContent(element, options);
                }
            }
            return UnknownFetchTieringCostInfoRequest.DeserializeUnknownFetchTieringCostInfoRequest(element, options);
        }

        BinaryData IPersistableModel<FetchTieringCostInfoContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FetchTieringCostInfoContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(FetchTieringCostInfoContent)} does not support writing '{options.Format}' format.");
            }
        }

        FetchTieringCostInfoContent IPersistableModel<FetchTieringCostInfoContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FetchTieringCostInfoContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeFetchTieringCostInfoContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(FetchTieringCostInfoContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<FetchTieringCostInfoContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
