// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Enabled or Disabled. </summary>
    public readonly partial struct EnhancedSecurityState : IEquatable<EnhancedSecurityState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EnhancedSecurityState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EnhancedSecurityState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Invalid. </summary>
        public static EnhancedSecurityState Invalid { get; } = new EnhancedSecurityState(InvalidValue);
        /// <summary> Enabled. </summary>
        public static EnhancedSecurityState Enabled { get; } = new EnhancedSecurityState(EnabledValue);
        /// <summary> Disabled. </summary>
        public static EnhancedSecurityState Disabled { get; } = new EnhancedSecurityState(DisabledValue);
        /// <summary> Determines if two <see cref="EnhancedSecurityState"/> values are the same. </summary>
        public static bool operator ==(EnhancedSecurityState left, EnhancedSecurityState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EnhancedSecurityState"/> values are not the same. </summary>
        public static bool operator !=(EnhancedSecurityState left, EnhancedSecurityState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EnhancedSecurityState"/>. </summary>
        public static implicit operator EnhancedSecurityState(string value) => new EnhancedSecurityState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EnhancedSecurityState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EnhancedSecurityState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
