// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> This is used to represent the various nodes of the distributed container. </summary>
    public partial class DistributedNodesInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DistributedNodesInfo"/>. </summary>
        public DistributedNodesInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DistributedNodesInfo"/>. </summary>
        /// <param name="nodeName"> Name of the node under a distributed container. </param>
        /// <param name="status">
        /// Status of this Node.
        /// Failed | Succeeded
        /// </param>
        /// <param name="errorDetail"> Error Details if the Status is non-success. </param>
        /// <param name="sourceResourceId"> ARM resource id of the node. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DistributedNodesInfo(string nodeName, string status, BackupErrorDetail errorDetail, string sourceResourceId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            NodeName = nodeName;
            Status = status;
            ErrorDetail = errorDetail;
            SourceResourceId = sourceResourceId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the node under a distributed container. </summary>
        public string NodeName { get; set; }
        /// <summary>
        /// Status of this Node.
        /// Failed | Succeeded
        /// </summary>
        public string Status { get; set; }
        /// <summary> Error Details if the Status is non-success. </summary>
        public BackupErrorDetail ErrorDetail { get; set; }
        /// <summary> ARM resource id of the node. </summary>
        public string SourceResourceId { get; set; }
    }
}
