// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> DataMove Level. </summary>
    public readonly partial struct DataMoveLevel : IEquatable<DataMoveLevel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataMoveLevel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataMoveLevel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string VaultValue = "Vault";
        private const string ContainerValue = "Container";

        /// <summary> Invalid. </summary>
        public static DataMoveLevel Invalid { get; } = new DataMoveLevel(InvalidValue);
        /// <summary> Vault. </summary>
        public static DataMoveLevel Vault { get; } = new DataMoveLevel(VaultValue);
        /// <summary> Container. </summary>
        public static DataMoveLevel Container { get; } = new DataMoveLevel(ContainerValue);
        /// <summary> Determines if two <see cref="DataMoveLevel"/> values are the same. </summary>
        public static bool operator ==(DataMoveLevel left, DataMoveLevel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataMoveLevel"/> values are not the same. </summary>
        public static bool operator !=(DataMoveLevel left, DataMoveLevel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataMoveLevel"/>. </summary>
        public static implicit operator DataMoveLevel(string value) => new DataMoveLevel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataMoveLevel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataMoveLevel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
