// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Container identity information. </summary>
    public partial class ContainerIdentityInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerIdentityInfo"/>. </summary>
        public ContainerIdentityInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContainerIdentityInfo"/>. </summary>
        /// <param name="uniqueName"> Unique name of the container. </param>
        /// <param name="aadTenantId"> Protection container identity - AAD Tenant. </param>
        /// <param name="servicePrincipalClientId"> Protection container identity - AAD Service Principal. </param>
        /// <param name="audience"> Protection container identity - Audience. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerIdentityInfo(string uniqueName, Guid? aadTenantId, string servicePrincipalClientId, string audience, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            UniqueName = uniqueName;
            AadTenantId = aadTenantId;
            ServicePrincipalClientId = servicePrincipalClientId;
            Audience = audience;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Unique name of the container. </summary>
        public string UniqueName { get; set; }
        /// <summary> Protection container identity - AAD Tenant. </summary>
        public Guid? AadTenantId { get; set; }
        /// <summary> Protection container identity - AAD Service Principal. </summary>
        public string ServicePrincipalClientId { get; set; }
        /// <summary> Protection container identity - Audience. </summary>
        public string Audience { get; set; }
    }
}
