// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    public partial class ContainerIdentityInfo : IUtf8JsonSerializable, IJsonModel<ContainerIdentityInfo>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ContainerIdentityInfo>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ContainerIdentityInfo>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerIdentityInfo>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ContainerIdentityInfo)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(UniqueName))
            {
                writer.WritePropertyName("uniqueName"u8);
                writer.WriteStringValue(UniqueName);
            }
            if (Optional.IsDefined(AadTenantId))
            {
                writer.WritePropertyName("aadTenantId"u8);
                writer.WriteStringValue(AadTenantId.Value);
            }
            if (Optional.IsDefined(ServicePrincipalClientId))
            {
                writer.WritePropertyName("servicePrincipalClientId"u8);
                writer.WriteStringValue(ServicePrincipalClientId);
            }
            if (Optional.IsDefined(Audience))
            {
                writer.WritePropertyName("audience"u8);
                writer.WriteStringValue(Audience);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ContainerIdentityInfo IJsonModel<ContainerIdentityInfo>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerIdentityInfo>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ContainerIdentityInfo)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeContainerIdentityInfo(document.RootElement, options);
        }

        internal static ContainerIdentityInfo DeserializeContainerIdentityInfo(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string uniqueName = default;
            Guid? aadTenantId = default;
            string servicePrincipalClientId = default;
            string audience = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("uniqueName"u8))
                {
                    uniqueName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("aadTenantId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    aadTenantId = property.Value.GetGuid();
                    continue;
                }
                if (property.NameEquals("servicePrincipalClientId"u8))
                {
                    servicePrincipalClientId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("audience"u8))
                {
                    audience = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ContainerIdentityInfo(uniqueName, aadTenantId, servicePrincipalClientId, audience, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ContainerIdentityInfo>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerIdentityInfo>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ContainerIdentityInfo)} does not support writing '{options.Format}' format.");
            }
        }

        ContainerIdentityInfo IPersistableModel<ContainerIdentityInfo>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerIdentityInfo>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeContainerIdentityInfo(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ContainerIdentityInfo)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ContainerIdentityInfo>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
