// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> BEK is bitlocker encryption key. </summary>
    public partial class BekDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BekDetails"/>. </summary>
        public BekDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BekDetails"/>. </summary>
        /// <param name="secretUri"> Secret is BEK. </param>
        /// <param name="secretVaultId"> ID of the Key Vault where this Secret is stored. </param>
        /// <param name="secretData"> BEK data. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BekDetails(Uri secretUri, ResourceIdentifier secretVaultId, string secretData, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SecretUri = secretUri;
            SecretVaultId = secretVaultId;
            SecretData = secretData;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Secret is BEK. </summary>
        public Uri SecretUri { get; set; }
        /// <summary> ID of the Key Vault where this Secret is stored. </summary>
        public ResourceIdentifier SecretVaultId { get; set; }
        /// <summary> BEK data. </summary>
        public string SecretData { get; set; }
    }
}
