// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    internal static partial class BackupWeekOfMonthExtensions
    {
        public static string ToSerialString(this BackupWeekOfMonth value) => value switch
        {
            BackupWeekOfMonth.First => "First",
            BackupWeekOfMonth.Second => "Second",
            BackupWeekOfMonth.Third => "Third",
            BackupWeekOfMonth.Fourth => "Fourth",
            BackupWeekOfMonth.Last => "Last",
            BackupWeekOfMonth.Invalid => "Invalid",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BackupWeekOfMonth value.")
        };

        public static BackupWeekOfMonth ToBackupWeekOfMonth(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "First")) return BackupWeekOfMonth.First;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Second")) return BackupWeekOfMonth.Second;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Third")) return BackupWeekOfMonth.Third;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Fourth")) return BackupWeekOfMonth.Fourth;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Last")) return BackupWeekOfMonth.Last;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Invalid")) return BackupWeekOfMonth.Invalid;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BackupWeekOfMonth value.");
        }
    }
}
