// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Validation Status. </summary>
    public readonly partial struct BackupValidationStatus : IEquatable<BackupValidationStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BackupValidationStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BackupValidationStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";

        /// <summary> Invalid. </summary>
        public static BackupValidationStatus Invalid { get; } = new BackupValidationStatus(InvalidValue);
        /// <summary> Succeeded. </summary>
        public static BackupValidationStatus Succeeded { get; } = new BackupValidationStatus(SucceededValue);
        /// <summary> Failed. </summary>
        public static BackupValidationStatus Failed { get; } = new BackupValidationStatus(FailedValue);
        /// <summary> Determines if two <see cref="BackupValidationStatus"/> values are the same. </summary>
        public static bool operator ==(BackupValidationStatus left, BackupValidationStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BackupValidationStatus"/> values are not the same. </summary>
        public static bool operator !=(BackupValidationStatus left, BackupValidationStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BackupValidationStatus"/>. </summary>
        public static implicit operator BackupValidationStatus(string value) => new BackupValidationStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BackupValidationStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BackupValidationStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
