// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Unit of the usage. </summary>
    public readonly partial struct BackupUsagesUnit : IEquatable<BackupUsagesUnit>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BackupUsagesUnit"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BackupUsagesUnit(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CountValue = "Count";
        private const string BytesValue = "Bytes";
        private const string SecondsValue = "Seconds";
        private const string PercentValue = "Percent";
        private const string CountPerSecondValue = "CountPerSecond";
        private const string BytesPerSecondValue = "BytesPerSecond";

        /// <summary> Count. </summary>
        public static BackupUsagesUnit Count { get; } = new BackupUsagesUnit(CountValue);
        /// <summary> Bytes. </summary>
        public static BackupUsagesUnit Bytes { get; } = new BackupUsagesUnit(BytesValue);
        /// <summary> Seconds. </summary>
        public static BackupUsagesUnit Seconds { get; } = new BackupUsagesUnit(SecondsValue);
        /// <summary> Percent. </summary>
        public static BackupUsagesUnit Percent { get; } = new BackupUsagesUnit(PercentValue);
        /// <summary> CountPerSecond. </summary>
        public static BackupUsagesUnit CountPerSecond { get; } = new BackupUsagesUnit(CountPerSecondValue);
        /// <summary> BytesPerSecond. </summary>
        public static BackupUsagesUnit BytesPerSecond { get; } = new BackupUsagesUnit(BytesPerSecondValue);
        /// <summary> Determines if two <see cref="BackupUsagesUnit"/> values are the same. </summary>
        public static bool operator ==(BackupUsagesUnit left, BackupUsagesUnit right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BackupUsagesUnit"/> values are not the same. </summary>
        public static bool operator !=(BackupUsagesUnit left, BackupUsagesUnit right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BackupUsagesUnit"/>. </summary>
        public static implicit operator BackupUsagesUnit(string value) => new BackupUsagesUnit(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BackupUsagesUnit other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BackupUsagesUnit other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
