// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Type of backup, viz. Full, Differential, Log or CopyOnlyFull. </summary>
    public readonly partial struct BackupType : IEquatable<BackupType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BackupType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BackupType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string FullValue = "Full";
        private const string DifferentialValue = "Differential";
        private const string LogValue = "Log";
        private const string CopyOnlyFullValue = "CopyOnlyFull";
        private const string IncrementalValue = "Incremental";
        private const string SnapshotFullValue = "SnapshotFull";
        private const string SnapshotCopyOnlyFullValue = "SnapshotCopyOnlyFull";

        /// <summary> Invalid. </summary>
        public static BackupType Invalid { get; } = new BackupType(InvalidValue);
        /// <summary> Full. </summary>
        public static BackupType Full { get; } = new BackupType(FullValue);
        /// <summary> Differential. </summary>
        public static BackupType Differential { get; } = new BackupType(DifferentialValue);
        /// <summary> Log. </summary>
        public static BackupType Log { get; } = new BackupType(LogValue);
        /// <summary> CopyOnlyFull. </summary>
        public static BackupType CopyOnlyFull { get; } = new BackupType(CopyOnlyFullValue);
        /// <summary> Incremental. </summary>
        public static BackupType Incremental { get; } = new BackupType(IncrementalValue);
        /// <summary> SnapshotFull. </summary>
        public static BackupType SnapshotFull { get; } = new BackupType(SnapshotFullValue);
        /// <summary> SnapshotCopyOnlyFull. </summary>
        public static BackupType SnapshotCopyOnlyFull { get; } = new BackupType(SnapshotCopyOnlyFullValue);
        /// <summary> Determines if two <see cref="BackupType"/> values are the same. </summary>
        public static bool operator ==(BackupType left, BackupType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BackupType"/> values are not the same. </summary>
        public static bool operator !=(BackupType left, BackupType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BackupType"/>. </summary>
        public static implicit operator BackupType(string value) => new BackupType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BackupType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BackupType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
