// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary>
    /// Tiering Policy for a target tier.
    /// If the policy is not specified for a given target tier, service retains the existing configured tiering policy for that tier
    /// </summary>
    public partial class BackupTieringPolicy
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BackupTieringPolicy"/>. </summary>
        public BackupTieringPolicy()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BackupTieringPolicy"/>. </summary>
        /// <param name="tieringMode">
        /// Tiering Mode to control automatic tiering of recovery points. Supported values are:
        /// 1. TierRecommended: Tier all recovery points recommended to be tiered
        /// 2. TierAfter: Tier all recovery points after a fixed period, as specified in duration + durationType below.
        /// 3. DoNotTier: Do not tier any recovery points
        /// </param>
        /// <param name="durationValue">
        /// Number of days/weeks/months/years to retain backups in current tier before tiering.
        /// Used only if TieringMode is set to TierAfter
        /// </param>
        /// <param name="durationType">
        /// Retention duration type: days/weeks/months/years
        /// Used only if TieringMode is set to TierAfter
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BackupTieringPolicy(TieringMode? tieringMode, int? durationValue, RetentionDurationType? durationType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TieringMode = tieringMode;
            DurationValue = durationValue;
            DurationType = durationType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// Tiering Mode to control automatic tiering of recovery points. Supported values are:
        /// 1. TierRecommended: Tier all recovery points recommended to be tiered
        /// 2. TierAfter: Tier all recovery points after a fixed period, as specified in duration + durationType below.
        /// 3. DoNotTier: Do not tier any recovery points
        /// </summary>
        public TieringMode? TieringMode { get; set; }
        /// <summary>
        /// Number of days/weeks/months/years to retain backups in current tier before tiering.
        /// Used only if TieringMode is set to TierAfter
        /// </summary>
        public int? DurationValue { get; set; }
        /// <summary>
        /// Retention duration type: days/weeks/months/years
        /// Used only if TieringMode is set to TierAfter
        /// </summary>
        public RetentionDurationType? DurationType { get; set; }
    }
}
