// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    public partial class BackupTargetDiskNetworkAccessSettings : IUtf8JsonSerializable, IJsonModel<BackupTargetDiskNetworkAccessSettings>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<BackupTargetDiskNetworkAccessSettings>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<BackupTargetDiskNetworkAccessSettings>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BackupTargetDiskNetworkAccessSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BackupTargetDiskNetworkAccessSettings)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(TargetDiskNetworkAccessOption))
            {
                writer.WritePropertyName("targetDiskNetworkAccessOption"u8);
                writer.WriteStringValue(TargetDiskNetworkAccessOption.Value.ToSerialString());
            }
            if (Optional.IsDefined(TargetDiskAccessId))
            {
                writer.WritePropertyName("targetDiskAccessId"u8);
                writer.WriteStringValue(TargetDiskAccessId);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        BackupTargetDiskNetworkAccessSettings IJsonModel<BackupTargetDiskNetworkAccessSettings>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BackupTargetDiskNetworkAccessSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BackupTargetDiskNetworkAccessSettings)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeBackupTargetDiskNetworkAccessSettings(document.RootElement, options);
        }

        internal static BackupTargetDiskNetworkAccessSettings DeserializeBackupTargetDiskNetworkAccessSettings(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            BackupTargetDiskNetworkAccessOption? targetDiskNetworkAccessOption = default;
            ResourceIdentifier targetDiskAccessId = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("targetDiskNetworkAccessOption"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    targetDiskNetworkAccessOption = property.Value.GetString().ToBackupTargetDiskNetworkAccessOption();
                    continue;
                }
                if (property.NameEquals("targetDiskAccessId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    targetDiskAccessId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new BackupTargetDiskNetworkAccessSettings(targetDiskNetworkAccessOption, targetDiskAccessId, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<BackupTargetDiskNetworkAccessSettings>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BackupTargetDiskNetworkAccessSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(BackupTargetDiskNetworkAccessSettings)} does not support writing '{options.Format}' format.");
            }
        }

        BackupTargetDiskNetworkAccessSettings IPersistableModel<BackupTargetDiskNetworkAccessSettings>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BackupTargetDiskNetworkAccessSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeBackupTargetDiskNetworkAccessSettings(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(BackupTargetDiskNetworkAccessSettings)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<BackupTargetDiskNetworkAccessSettings>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
