// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> BackupStatus response. </summary>
    public partial class BackupStatusResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BackupStatusResult"/>. </summary>
        internal BackupStatusResult()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BackupStatusResult"/>. </summary>
        /// <param name="protectionStatus"> Specifies whether the container is registered or not. </param>
        /// <param name="vaultId"> Specifies the arm resource id of the vault. </param>
        /// <param name="fabricName"> Specifies the fabric name - Azure or AD. </param>
        /// <param name="containerName"> Specifies the product specific container name. E.g. iaasvmcontainer;iaasvmcontainer;csname;vmname. </param>
        /// <param name="protectedItemName"> Specifies the product specific ds name. E.g. vm;iaasvmcontainer;csname;vmname. </param>
        /// <param name="errorCode"> ErrorCode in case of intent failed. </param>
        /// <param name="errorMessage"> ErrorMessage in case of intent failed. </param>
        /// <param name="policyName"> Specifies the policy name which is used for protection. </param>
        /// <param name="registrationStatus"> Container registration status. </param>
        /// <param name="protectedItemsCount"> Number of protected items. </param>
        /// <param name="acquireStorageAccountLock"> Specifies whether the storage account lock has been acquired or not. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BackupStatusResult(BackupProtectionStatus? protectionStatus, ResourceIdentifier vaultId, BackupFabricName? fabricName, string containerName, string protectedItemName, string errorCode, string errorMessage, string policyName, string registrationStatus, int? protectedItemsCount, AcquireStorageAccountLock? acquireStorageAccountLock, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProtectionStatus = protectionStatus;
            VaultId = vaultId;
            FabricName = fabricName;
            ContainerName = containerName;
            ProtectedItemName = protectedItemName;
            ErrorCode = errorCode;
            ErrorMessage = errorMessage;
            PolicyName = policyName;
            RegistrationStatus = registrationStatus;
            ProtectedItemsCount = protectedItemsCount;
            AcquireStorageAccountLock = acquireStorageAccountLock;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Specifies whether the container is registered or not. </summary>
        public BackupProtectionStatus? ProtectionStatus { get; }
        /// <summary> Specifies the arm resource id of the vault. </summary>
        public ResourceIdentifier VaultId { get; }
        /// <summary> Specifies the fabric name - Azure or AD. </summary>
        public BackupFabricName? FabricName { get; }
        /// <summary> Specifies the product specific container name. E.g. iaasvmcontainer;iaasvmcontainer;csname;vmname. </summary>
        public string ContainerName { get; }
        /// <summary> Specifies the product specific ds name. E.g. vm;iaasvmcontainer;csname;vmname. </summary>
        public string ProtectedItemName { get; }
        /// <summary> ErrorCode in case of intent failed. </summary>
        public string ErrorCode { get; }
        /// <summary> ErrorMessage in case of intent failed. </summary>
        public string ErrorMessage { get; }
        /// <summary> Specifies the policy name which is used for protection. </summary>
        public string PolicyName { get; }
        /// <summary> Container registration status. </summary>
        public string RegistrationStatus { get; }
        /// <summary> Number of protected items. </summary>
        public int? ProtectedItemsCount { get; }
        /// <summary> Specifies whether the storage account lock has been acquired or not. </summary>
        public AcquireStorageAccountLock? AcquireStorageAccountLock { get; }
    }
}
