// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> AzureBackupServer (DPMVenus) workload-specific protection container. </summary>
    public partial class BackupServerContainer : DpmContainer
    {
        /// <summary> Initializes a new instance of <see cref="BackupServerContainer"/>. </summary>
        public BackupServerContainer()
        {
            ContainerType = ProtectableContainerType.AzureBackupServerContainer;
        }

        /// <summary> Initializes a new instance of <see cref="BackupServerContainer"/>. </summary>
        /// <param name="friendlyName"> Friendly name of the container. </param>
        /// <param name="backupManagementType"> Type of backup management for the container. </param>
        /// <param name="registrationStatus"> Status of registration of the container with the Recovery Services Vault. </param>
        /// <param name="healthStatus"> Status of health of the container. </param>
        /// <param name="containerType">
        /// Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        /// Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        /// Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        /// Backup is VMAppContainer
        /// </param>
        /// <param name="protectableObjectType"> Type of the protectable object associated with this container. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="canReRegister"> Specifies whether the container is re-registrable. </param>
        /// <param name="containerId"> ID of container. </param>
        /// <param name="protectedItemCount"> Number of protected items in the BackupEngine. </param>
        /// <param name="dpmAgentVersion"> Backup engine Agent version. </param>
        /// <param name="dpmServers"> List of BackupEngines protecting the container. </param>
        /// <param name="isUpgradeAvailable"> To check if upgrade available. </param>
        /// <param name="protectionStatus"> Protection status of the container. </param>
        /// <param name="extendedInfo"> Extended Info of the container. </param>
        internal BackupServerContainer(string friendlyName, BackupManagementType? backupManagementType, string registrationStatus, string healthStatus, ProtectableContainerType containerType, string protectableObjectType, IDictionary<string, BinaryData> serializedAdditionalRawData, bool? canReRegister, string containerId, long? protectedItemCount, string dpmAgentVersion, IList<string> dpmServers, bool? isUpgradeAvailable, string protectionStatus, DpmContainerExtendedInfo extendedInfo) : base(friendlyName, backupManagementType, registrationStatus, healthStatus, containerType, protectableObjectType, serializedAdditionalRawData, canReRegister, containerId, protectedItemCount, dpmAgentVersion, dpmServers, isUpgradeAvailable, protectionStatus, extendedInfo)
        {
            ContainerType = containerType;
        }
    }
}
