// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    public partial class BackupResourceVaultConfigProperties : IUtf8JsonSerializable, IJsonModel<BackupResourceVaultConfigProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<BackupResourceVaultConfigProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<BackupResourceVaultConfigProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BackupResourceVaultConfigProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BackupResourceVaultConfigProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(StorageModelType))
            {
                writer.WritePropertyName("storageModelType"u8);
                writer.WriteStringValue(StorageModelType.Value.ToString());
            }
            if (Optional.IsDefined(StorageType))
            {
                writer.WritePropertyName("storageType"u8);
                writer.WriteStringValue(StorageType.Value.ToString());
            }
            if (Optional.IsDefined(StorageTypeState))
            {
                writer.WritePropertyName("storageTypeState"u8);
                writer.WriteStringValue(StorageTypeState.Value.ToString());
            }
            if (Optional.IsDefined(EnhancedSecurityState))
            {
                writer.WritePropertyName("enhancedSecurityState"u8);
                writer.WriteStringValue(EnhancedSecurityState.Value.ToString());
            }
            if (Optional.IsDefined(SoftDeleteFeatureState))
            {
                writer.WritePropertyName("softDeleteFeatureState"u8);
                writer.WriteStringValue(SoftDeleteFeatureState.Value.ToString());
            }
            if (Optional.IsDefined(SoftDeleteRetentionPeriodInDays))
            {
                writer.WritePropertyName("softDeleteRetentionPeriodInDays"u8);
                writer.WriteNumberValue(SoftDeleteRetentionPeriodInDays.Value);
            }
            if (Optional.IsCollectionDefined(ResourceGuardOperationRequests))
            {
                writer.WritePropertyName("resourceGuardOperationRequests"u8);
                writer.WriteStartArray();
                foreach (var item in ResourceGuardOperationRequests)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(IsSoftDeleteFeatureStateEditable))
            {
                writer.WritePropertyName("isSoftDeleteFeatureStateEditable"u8);
                writer.WriteBooleanValue(IsSoftDeleteFeatureStateEditable.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        BackupResourceVaultConfigProperties IJsonModel<BackupResourceVaultConfigProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BackupResourceVaultConfigProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BackupResourceVaultConfigProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeBackupResourceVaultConfigProperties(document.RootElement, options);
        }

        internal static BackupResourceVaultConfigProperties DeserializeBackupResourceVaultConfigProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            BackupStorageType? storageModelType = default;
            BackupStorageType? storageType = default;
            BackupStorageTypeState? storageTypeState = default;
            EnhancedSecurityState? enhancedSecurityState = default;
            SoftDeleteFeatureState? softDeleteFeatureState = default;
            int? softDeleteRetentionPeriodInDays = default;
            IList<string> resourceGuardOperationRequests = default;
            bool? isSoftDeleteFeatureStateEditable = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("storageModelType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    storageModelType = new BackupStorageType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("storageType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    storageType = new BackupStorageType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("storageTypeState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    storageTypeState = new BackupStorageTypeState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("enhancedSecurityState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    enhancedSecurityState = new EnhancedSecurityState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("softDeleteFeatureState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    softDeleteFeatureState = new SoftDeleteFeatureState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("softDeleteRetentionPeriodInDays"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    softDeleteRetentionPeriodInDays = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("resourceGuardOperationRequests"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    resourceGuardOperationRequests = array;
                    continue;
                }
                if (property.NameEquals("isSoftDeleteFeatureStateEditable"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isSoftDeleteFeatureStateEditable = property.Value.GetBoolean();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new BackupResourceVaultConfigProperties(
                storageModelType,
                storageType,
                storageTypeState,
                enhancedSecurityState,
                softDeleteFeatureState,
                softDeleteRetentionPeriodInDays,
                resourceGuardOperationRequests ?? new ChangeTrackingList<string>(),
                isSoftDeleteFeatureStateEditable,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<BackupResourceVaultConfigProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BackupResourceVaultConfigProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(BackupResourceVaultConfigProperties)} does not support writing '{options.Format}' format.");
            }
        }

        BackupResourceVaultConfigProperties IPersistableModel<BackupResourceVaultConfigProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BackupResourceVaultConfigProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeBackupResourceVaultConfigProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(BackupResourceVaultConfigProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<BackupResourceVaultConfigProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
