// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> The BackupResourceEncryptionConfig. </summary>
    public partial class BackupResourceEncryptionConfig
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BackupResourceEncryptionConfig"/>. </summary>
        public BackupResourceEncryptionConfig()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BackupResourceEncryptionConfig"/>. </summary>
        /// <param name="encryptionAtRestType"> Encryption At Rest Type. </param>
        /// <param name="keyUri"> Key Vault Key URI. </param>
        /// <param name="subscriptionId"> Key Vault Subscription Id. </param>
        /// <param name="lastUpdateStatus"></param>
        /// <param name="infrastructureEncryptionState"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BackupResourceEncryptionConfig(BackupEncryptionAtRestType? encryptionAtRestType, Uri keyUri, string subscriptionId, LastUpdateStatus? lastUpdateStatus, InfrastructureEncryptionState? infrastructureEncryptionState, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            EncryptionAtRestType = encryptionAtRestType;
            KeyUri = keyUri;
            SubscriptionId = subscriptionId;
            LastUpdateStatus = lastUpdateStatus;
            InfrastructureEncryptionState = infrastructureEncryptionState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Encryption At Rest Type. </summary>
        public BackupEncryptionAtRestType? EncryptionAtRestType { get; set; }
        /// <summary> Key Vault Key URI. </summary>
        public Uri KeyUri { get; set; }
        /// <summary> Key Vault Subscription Id. </summary>
        public string SubscriptionId { get; set; }
        /// <summary> Gets or sets the last update status. </summary>
        public LastUpdateStatus? LastUpdateStatus { get; set; }
        /// <summary> Gets or sets the infrastructure encryption state. </summary>
        public InfrastructureEncryptionState? InfrastructureEncryptionState { get; set; }
    }
}
