// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> The resource storage details. </summary>
    public partial class BackupResourceConfigProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BackupResourceConfigProperties"/>. </summary>
        public BackupResourceConfigProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BackupResourceConfigProperties"/>. </summary>
        /// <param name="storageModelType"> Storage type. </param>
        /// <param name="storageType"> Storage type. </param>
        /// <param name="storageTypeState"> Locked or Unlocked. Once a machine is registered against a resource, the storageTypeState is always Locked. </param>
        /// <param name="enableCrossRegionRestore"> Opt in details of Cross Region Restore feature. </param>
        /// <param name="dedupState"> Vault Dedup state. </param>
        /// <param name="xcoolState"> Vault x-cool state. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BackupResourceConfigProperties(BackupStorageType? storageModelType, BackupStorageType? storageType, BackupStorageTypeState? storageTypeState, bool? enableCrossRegionRestore, VaultDedupState? dedupState, VaultXcoolState? xcoolState, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            StorageModelType = storageModelType;
            StorageType = storageType;
            StorageTypeState = storageTypeState;
            EnableCrossRegionRestore = enableCrossRegionRestore;
            DedupState = dedupState;
            XcoolState = xcoolState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Storage type. </summary>
        public BackupStorageType? StorageModelType { get; set; }
        /// <summary> Storage type. </summary>
        public BackupStorageType? StorageType { get; set; }
        /// <summary> Locked or Unlocked. Once a machine is registered against a resource, the storageTypeState is always Locked. </summary>
        public BackupStorageTypeState? StorageTypeState { get; set; }
        /// <summary> Opt in details of Cross Region Restore feature. </summary>
        public bool? EnableCrossRegionRestore { get; set; }
        /// <summary> Vault Dedup state. </summary>
        public VaultDedupState? DedupState { get; set; }
        /// <summary> Vault x-cool state. </summary>
        public VaultXcoolState? XcoolState { get; set; }
    }
}
