// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Specifies whether the container is registered or not. </summary>
    public readonly partial struct BackupProtectionStatus : IEquatable<BackupProtectionStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BackupProtectionStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BackupProtectionStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string NotProtectedValue = "NotProtected";
        private const string ProtectingValue = "Protecting";
        private const string ProtectedValue = "Protected";
        private const string ProtectionFailedValue = "ProtectionFailed";

        /// <summary> Invalid. </summary>
        public static BackupProtectionStatus Invalid { get; } = new BackupProtectionStatus(InvalidValue);
        /// <summary> NotProtected. </summary>
        public static BackupProtectionStatus NotProtected { get; } = new BackupProtectionStatus(NotProtectedValue);
        /// <summary> Protecting. </summary>
        public static BackupProtectionStatus Protecting { get; } = new BackupProtectionStatus(ProtectingValue);
        /// <summary> Protected. </summary>
        public static BackupProtectionStatus Protected { get; } = new BackupProtectionStatus(ProtectedValue);
        /// <summary> ProtectionFailed. </summary>
        public static BackupProtectionStatus ProtectionFailed { get; } = new BackupProtectionStatus(ProtectionFailedValue);
        /// <summary> Determines if two <see cref="BackupProtectionStatus"/> values are the same. </summary>
        public static bool operator ==(BackupProtectionStatus left, BackupProtectionStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BackupProtectionStatus"/> values are not the same. </summary>
        public static bool operator !=(BackupProtectionStatus left, BackupProtectionStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BackupProtectionStatus"/>. </summary>
        public static implicit operator BackupProtectionStatus(string value) => new BackupProtectionStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BackupProtectionStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BackupProtectionStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
