// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Backup state of this backup item. </summary>
    public readonly partial struct BackupProtectionState : IEquatable<BackupProtectionState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BackupProtectionState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BackupProtectionState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string IRPendingValue = "IRPending";
        private const string ProtectedValue = "Protected";
        private const string ProtectionErrorValue = "ProtectionError";
        private const string ProtectionStoppedValue = "ProtectionStopped";
        private const string ProtectionPausedValue = "ProtectionPaused";
        private const string BackupsSuspendedValue = "BackupsSuspended";

        /// <summary> Invalid. </summary>
        public static BackupProtectionState Invalid { get; } = new BackupProtectionState(InvalidValue);
        /// <summary> IRPending. </summary>
        public static BackupProtectionState IRPending { get; } = new BackupProtectionState(IRPendingValue);
        /// <summary> Protected. </summary>
        public static BackupProtectionState Protected { get; } = new BackupProtectionState(ProtectedValue);
        /// <summary> ProtectionError. </summary>
        public static BackupProtectionState ProtectionError { get; } = new BackupProtectionState(ProtectionErrorValue);
        /// <summary> ProtectionStopped. </summary>
        public static BackupProtectionState ProtectionStopped { get; } = new BackupProtectionState(ProtectionStoppedValue);
        /// <summary> ProtectionPaused. </summary>
        public static BackupProtectionState ProtectionPaused { get; } = new BackupProtectionState(ProtectionPausedValue);
        /// <summary> BackupsSuspended. </summary>
        public static BackupProtectionState BackupsSuspended { get; } = new BackupProtectionState(BackupsSuspendedValue);
        /// <summary> Determines if two <see cref="BackupProtectionState"/> values are the same. </summary>
        public static bool operator ==(BackupProtectionState left, BackupProtectionState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BackupProtectionState"/> values are not the same. </summary>
        public static bool operator !=(BackupProtectionState left, BackupProtectionState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BackupProtectionState"/>. </summary>
        public static implicit operator BackupProtectionState(string value) => new BackupProtectionState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BackupProtectionState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BackupProtectionState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
