// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Gets or sets provisioning state of the private endpoint connection. </summary>
    public readonly partial struct BackupPrivateEndpointConnectionProvisioningState : IEquatable<BackupPrivateEndpointConnectionProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BackupPrivateEndpointConnectionProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BackupPrivateEndpointConnectionProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string DeletingValue = "Deleting";
        private const string FailedValue = "Failed";
        private const string PendingValue = "Pending";

        /// <summary> Succeeded. </summary>
        public static BackupPrivateEndpointConnectionProvisioningState Succeeded { get; } = new BackupPrivateEndpointConnectionProvisioningState(SucceededValue);
        /// <summary> Deleting. </summary>
        public static BackupPrivateEndpointConnectionProvisioningState Deleting { get; } = new BackupPrivateEndpointConnectionProvisioningState(DeletingValue);
        /// <summary> Failed. </summary>
        public static BackupPrivateEndpointConnectionProvisioningState Failed { get; } = new BackupPrivateEndpointConnectionProvisioningState(FailedValue);
        /// <summary> Pending. </summary>
        public static BackupPrivateEndpointConnectionProvisioningState Pending { get; } = new BackupPrivateEndpointConnectionProvisioningState(PendingValue);
        /// <summary> Determines if two <see cref="BackupPrivateEndpointConnectionProvisioningState"/> values are the same. </summary>
        public static bool operator ==(BackupPrivateEndpointConnectionProvisioningState left, BackupPrivateEndpointConnectionProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BackupPrivateEndpointConnectionProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(BackupPrivateEndpointConnectionProvisioningState left, BackupPrivateEndpointConnectionProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BackupPrivateEndpointConnectionProvisioningState"/>. </summary>
        public static implicit operator BackupPrivateEndpointConnectionProvisioningState(string value) => new BackupPrivateEndpointConnectionProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BackupPrivateEndpointConnectionProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BackupPrivateEndpointConnectionProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
