// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    internal static partial class BackupMonthOfYearExtensions
    {
        public static string ToSerialString(this BackupMonthOfYear value) => value switch
        {
            BackupMonthOfYear.Invalid => "Invalid",
            BackupMonthOfYear.January => "January",
            BackupMonthOfYear.February => "February",
            BackupMonthOfYear.March => "March",
            BackupMonthOfYear.April => "April",
            BackupMonthOfYear.May => "May",
            BackupMonthOfYear.June => "June",
            BackupMonthOfYear.July => "July",
            BackupMonthOfYear.August => "August",
            BackupMonthOfYear.September => "September",
            BackupMonthOfYear.October => "October",
            BackupMonthOfYear.November => "November",
            BackupMonthOfYear.December => "December",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BackupMonthOfYear value.")
        };

        public static BackupMonthOfYear ToBackupMonthOfYear(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Invalid")) return BackupMonthOfYear.Invalid;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "January")) return BackupMonthOfYear.January;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "February")) return BackupMonthOfYear.February;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "March")) return BackupMonthOfYear.March;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "April")) return BackupMonthOfYear.April;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "May")) return BackupMonthOfYear.May;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "June")) return BackupMonthOfYear.June;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "July")) return BackupMonthOfYear.July;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "August")) return BackupMonthOfYear.August;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "September")) return BackupMonthOfYear.September;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "October")) return BackupMonthOfYear.October;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "November")) return BackupMonthOfYear.November;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "December")) return BackupMonthOfYear.December;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BackupMonthOfYear value.");
        }
    }
}
