// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Backup management type to execute the current job. </summary>
    public readonly partial struct BackupManagementType : IEquatable<BackupManagementType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BackupManagementType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BackupManagementType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string AzureIaasVmValue = "AzureIaasVM";
        private const string MabValue = "MAB";
        private const string DpmValue = "DPM";
        private const string AzureBackupServerValue = "AzureBackupServer";
        private const string AzureSqlValue = "AzureSql";
        private const string AzureStorageValue = "AzureStorage";
        private const string AzureWorkloadValue = "AzureWorkload";
        private const string DefaultBackupValue = "DefaultBackup";
        private const string BackupProtectedItemCountSummaryValue = "BackupProtectedItemCountSummary";
        private const string BackupProtectionContainerCountSummaryValue = "BackupProtectionContainerCountSummary";

        /// <summary> Invalid. </summary>
        public static BackupManagementType Invalid { get; } = new BackupManagementType(InvalidValue);
        /// <summary> AzureIaasVM. </summary>
        public static BackupManagementType AzureIaasVm { get; } = new BackupManagementType(AzureIaasVmValue);
        /// <summary> MAB. </summary>
        public static BackupManagementType Mab { get; } = new BackupManagementType(MabValue);
        /// <summary> DPM. </summary>
        public static BackupManagementType Dpm { get; } = new BackupManagementType(DpmValue);
        /// <summary> AzureBackupServer. </summary>
        public static BackupManagementType AzureBackupServer { get; } = new BackupManagementType(AzureBackupServerValue);
        /// <summary> AzureSql. </summary>
        public static BackupManagementType AzureSql { get; } = new BackupManagementType(AzureSqlValue);
        /// <summary> AzureStorage. </summary>
        public static BackupManagementType AzureStorage { get; } = new BackupManagementType(AzureStorageValue);
        /// <summary> AzureWorkload. </summary>
        public static BackupManagementType AzureWorkload { get; } = new BackupManagementType(AzureWorkloadValue);
        /// <summary> DefaultBackup. </summary>
        public static BackupManagementType DefaultBackup { get; } = new BackupManagementType(DefaultBackupValue);
        /// <summary> BackupProtectedItemCountSummary. </summary>
        public static BackupManagementType BackupProtectedItemCountSummary { get; } = new BackupManagementType(BackupProtectedItemCountSummaryValue);
        /// <summary> BackupProtectionContainerCountSummary. </summary>
        public static BackupManagementType BackupProtectionContainerCountSummary { get; } = new BackupManagementType(BackupProtectionContainerCountSummaryValue);
        /// <summary> Determines if two <see cref="BackupManagementType"/> values are the same. </summary>
        public static bool operator ==(BackupManagementType left, BackupManagementType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BackupManagementType"/> values are not the same. </summary>
        public static bool operator !=(BackupManagementType left, BackupManagementType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BackupManagementType"/>. </summary>
        public static implicit operator BackupManagementType(string value) => new BackupManagementType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BackupManagementType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BackupManagementType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
