// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Type of backup items associated with this container. </summary>
    public readonly partial struct BackupItemType : IEquatable<BackupItemType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BackupItemType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BackupItemType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string VmValue = "VM";
        private const string FileFolderValue = "FileFolder";
        private const string AzureSqlDBValue = "AzureSqlDb";
        private const string SqlDBValue = "SQLDB";
        private const string ExchangeValue = "Exchange";
        private const string SharepointValue = "Sharepoint";
        private const string VMwareVmValue = "VMwareVM";
        private const string SystemStateValue = "SystemState";
        private const string ClientValue = "Client";
        private const string GenericDataSourceValue = "GenericDataSource";
        private const string SqlDatabaseValue = "SQLDataBase";
        private const string AzureFileShareValue = "AzureFileShare";
        private const string SapHanaDatabaseValue = "SAPHanaDatabase";
        private const string SapAseDatabaseValue = "SAPAseDatabase";
        private const string SapHanaDBInstanceValue = "SAPHanaDBInstance";

        /// <summary> Invalid. </summary>
        public static BackupItemType Invalid { get; } = new BackupItemType(InvalidValue);
        /// <summary> VM. </summary>
        public static BackupItemType Vm { get; } = new BackupItemType(VmValue);
        /// <summary> FileFolder. </summary>
        public static BackupItemType FileFolder { get; } = new BackupItemType(FileFolderValue);
        /// <summary> AzureSqlDb. </summary>
        public static BackupItemType AzureSqlDB { get; } = new BackupItemType(AzureSqlDBValue);
        /// <summary> SQLDB. </summary>
        public static BackupItemType SqlDB { get; } = new BackupItemType(SqlDBValue);
        /// <summary> Exchange. </summary>
        public static BackupItemType Exchange { get; } = new BackupItemType(ExchangeValue);
        /// <summary> Sharepoint. </summary>
        public static BackupItemType Sharepoint { get; } = new BackupItemType(SharepointValue);
        /// <summary> VMwareVM. </summary>
        public static BackupItemType VMwareVm { get; } = new BackupItemType(VMwareVmValue);
        /// <summary> SystemState. </summary>
        public static BackupItemType SystemState { get; } = new BackupItemType(SystemStateValue);
        /// <summary> Client. </summary>
        public static BackupItemType Client { get; } = new BackupItemType(ClientValue);
        /// <summary> GenericDataSource. </summary>
        public static BackupItemType GenericDataSource { get; } = new BackupItemType(GenericDataSourceValue);
        /// <summary> SQLDataBase. </summary>
        public static BackupItemType SqlDatabase { get; } = new BackupItemType(SqlDatabaseValue);
        /// <summary> AzureFileShare. </summary>
        public static BackupItemType AzureFileShare { get; } = new BackupItemType(AzureFileShareValue);
        /// <summary> SAPHanaDatabase. </summary>
        public static BackupItemType SapHanaDatabase { get; } = new BackupItemType(SapHanaDatabaseValue);
        /// <summary> SAPAseDatabase. </summary>
        public static BackupItemType SapAseDatabase { get; } = new BackupItemType(SapAseDatabaseValue);
        /// <summary> SAPHanaDBInstance. </summary>
        public static BackupItemType SapHanaDBInstance { get; } = new BackupItemType(SapHanaDBInstanceValue);
        /// <summary> Determines if two <see cref="BackupItemType"/> values are the same. </summary>
        public static bool operator ==(BackupItemType left, BackupItemType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BackupItemType"/> values are not the same. </summary>
        public static bool operator !=(BackupItemType left, BackupItemType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BackupItemType"/>. </summary>
        public static implicit operator BackupItemType(string value) => new BackupItemType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BackupItemType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BackupItemType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
