// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> The BackupHourlySchedule. </summary>
    public partial class BackupHourlySchedule
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BackupHourlySchedule"/>. </summary>
        public BackupHourlySchedule()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BackupHourlySchedule"/>. </summary>
        /// <param name="interval">
        /// Interval at which backup needs to be triggered. For hourly the value
        ///  can be 4/6/8/12
        /// </param>
        /// <param name="scheduleWindowStartOn"> To specify start time of the backup window. </param>
        /// <param name="scheduleWindowDuration"> To specify duration of the backup window. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BackupHourlySchedule(int? interval, DateTimeOffset? scheduleWindowStartOn, int? scheduleWindowDuration, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Interval = interval;
            ScheduleWindowStartOn = scheduleWindowStartOn;
            ScheduleWindowDuration = scheduleWindowDuration;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// Interval at which backup needs to be triggered. For hourly the value
        ///  can be 4/6/8/12
        /// </summary>
        public int? Interval { get; set; }
        /// <summary> To specify start time of the backup window. </summary>
        public DateTimeOffset? ScheduleWindowStartOn { get; set; }
        /// <summary> To specify duration of the backup window. </summary>
        public int? ScheduleWindowDuration { get; set; }
    }
}
