// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> File Share type XSync or XSMB. </summary>
    public readonly partial struct BackupFileShareType : IEquatable<BackupFileShareType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BackupFileShareType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BackupFileShareType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string XsmbValue = "XSMB";
        private const string XSyncValue = "XSync";

        /// <summary> Invalid. </summary>
        public static BackupFileShareType Invalid { get; } = new BackupFileShareType(InvalidValue);
        /// <summary> XSMB. </summary>
        public static BackupFileShareType Xsmb { get; } = new BackupFileShareType(XsmbValue);
        /// <summary> XSync. </summary>
        public static BackupFileShareType XSync { get; } = new BackupFileShareType(XSyncValue);
        /// <summary> Determines if two <see cref="BackupFileShareType"/> values are the same. </summary>
        public static bool operator ==(BackupFileShareType left, BackupFileShareType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BackupFileShareType"/> values are not the same. </summary>
        public static bool operator !=(BackupFileShareType left, BackupFileShareType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BackupFileShareType"/>. </summary>
        public static implicit operator BackupFileShareType(string value) => new BackupFileShareType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BackupFileShareType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BackupFileShareType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
