// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Type of the backup engine. </summary>
    internal readonly partial struct BackupEngineType : IEquatable<BackupEngineType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BackupEngineType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BackupEngineType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string DpmBackupEngineValue = "DpmBackupEngine";
        private const string AzureBackupServerEngineValue = "AzureBackupServerEngine";

        /// <summary> Invalid. </summary>
        public static BackupEngineType Invalid { get; } = new BackupEngineType(InvalidValue);
        /// <summary> DpmBackupEngine. </summary>
        public static BackupEngineType DpmBackupEngine { get; } = new BackupEngineType(DpmBackupEngineValue);
        /// <summary> AzureBackupServerEngine. </summary>
        public static BackupEngineType AzureBackupServerEngine { get; } = new BackupEngineType(AzureBackupServerEngineValue);
        /// <summary> Determines if two <see cref="BackupEngineType"/> values are the same. </summary>
        public static bool operator ==(BackupEngineType left, BackupEngineType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BackupEngineType"/> values are not the same. </summary>
        public static bool operator !=(BackupEngineType left, BackupEngineType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BackupEngineType"/>. </summary>
        public static implicit operator BackupEngineType(string value) => new BackupEngineType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BackupEngineType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BackupEngineType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
