// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Encryption At Rest Type. </summary>
    public readonly partial struct BackupEncryptionAtRestType : IEquatable<BackupEncryptionAtRestType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BackupEncryptionAtRestType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BackupEncryptionAtRestType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string MicrosoftManagedValue = "MicrosoftManaged";
        private const string CustomerManagedValue = "CustomerManaged";

        /// <summary> Invalid. </summary>
        public static BackupEncryptionAtRestType Invalid { get; } = new BackupEncryptionAtRestType(InvalidValue);
        /// <summary> MicrosoftManaged. </summary>
        public static BackupEncryptionAtRestType MicrosoftManaged { get; } = new BackupEncryptionAtRestType(MicrosoftManagedValue);
        /// <summary> CustomerManaged. </summary>
        public static BackupEncryptionAtRestType CustomerManaged { get; } = new BackupEncryptionAtRestType(CustomerManagedValue);
        /// <summary> Determines if two <see cref="BackupEncryptionAtRestType"/> values are the same. </summary>
        public static bool operator ==(BackupEncryptionAtRestType left, BackupEncryptionAtRestType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BackupEncryptionAtRestType"/> values are not the same. </summary>
        public static bool operator !=(BackupEncryptionAtRestType left, BackupEncryptionAtRestType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BackupEncryptionAtRestType"/>. </summary>
        public static implicit operator BackupEncryptionAtRestType(string value) => new BackupEncryptionAtRestType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BackupEncryptionAtRestType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BackupEncryptionAtRestType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
