// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    internal static partial class BackupDayOfWeekExtensions
    {
        public static string ToSerialString(this BackupDayOfWeek value) => value switch
        {
            BackupDayOfWeek.Sunday => "Sunday",
            BackupDayOfWeek.Monday => "Monday",
            BackupDayOfWeek.Tuesday => "Tuesday",
            BackupDayOfWeek.Wednesday => "Wednesday",
            BackupDayOfWeek.Thursday => "Thursday",
            BackupDayOfWeek.Friday => "Friday",
            BackupDayOfWeek.Saturday => "Saturday",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BackupDayOfWeek value.")
        };

        public static BackupDayOfWeek ToBackupDayOfWeek(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Sunday")) return BackupDayOfWeek.Sunday;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Monday")) return BackupDayOfWeek.Monday;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Tuesday")) return BackupDayOfWeek.Tuesday;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Wednesday")) return BackupDayOfWeek.Wednesday;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Thursday")) return BackupDayOfWeek.Thursday;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Friday")) return BackupDayOfWeek.Friday;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Saturday")) return BackupDayOfWeek.Saturday;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BackupDayOfWeek value.");
        }
    }
}
